/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BasicVector_IntBuffer
extends AbstractVector {
    private int capacity;
    private IntBuffer elements;
    private boolean directAllocation;

    public BasicVector_IntBuffer(int capacity) {
        this(capacity, false);
    }

    public BasicVector_IntBuffer(int capacity, boolean directAllocation) {
        this.directAllocation = directAllocation;
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(capacity * 4);
            this.elements = b.asIntBuffer();
        } else {
            this.elements = IntBuffer.allocate(capacity);
        }
        this.capacity = capacity;
    }

    public BasicVector_IntBuffer(LispObject[] array, boolean directAllocation) {
        this.capacity = array.length;
        this.directAllocation = directAllocation;
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(this.capacity * 4);
            this.elements = b.asIntBuffer();
        } else {
            this.elements = IntBuffer.allocate(this.capacity);
        }
        int i = array.length;
        while (i-- > 0) {
            this.elements.put(i, (int)(array[i].longValue() & 0xFFFFFFFFL));
        }
    }

    public BasicVector_IntBuffer(ByteBuffer buffer, boolean directAllocation) {
        this.directAllocation = directAllocation;
        this.elements = buffer.asIntBuffer();
        this.capacity = buffer.limit() / 4;
    }

    public BasicVector_IntBuffer(IntBuffer buffer) {
        this(buffer, false);
    }

    public BasicVector_IntBuffer(IntBuffer buffer, boolean directAllocation) {
        this.directAllocation = directAllocation;
        this.elements = buffer;
        this.capacity = buffer.limit();
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, Lisp.UNSIGNED_BYTE_32, new Cons(Fixnum.getInstance(this.capacity)));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_32;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        try {
            return Lisp.number((long)this.elements.get(index) & 0xFFFFFFFFL);
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public int aref(int index) {
        try {
            return Lisp.number((long)this.elements.get(index) & 0xFFFFFFFFL).intValue();
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return -1;
        }
    }

    @Override
    public long aref_long(int index) {
        try {
            return (long)this.elements.get(index) & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return -1L;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return Lisp.number((long)this.elements.get(index) & 0xFFFFFFFFL);
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, LispObject newValue) {
        try {
            if (newValue.isLessThan(Fixnum.ZERO) || newValue.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
                Lisp.type_error(newValue, Lisp.UNSIGNED_BYTE_32);
            }
            this.elements.put(index, (int)(newValue.longValue() & 0xFFFFFFFFL));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        BasicVector_IntBuffer v = new BasicVector_IntBuffer(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.elements.put(j++, this.elements.get(i++));
            }
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof LispInteger)) {
            Lisp.type_error(obj, Symbol.INTEGER);
            return;
        }
        if (obj.isLessThan(Fixnum.ZERO) || obj.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_32);
        }
        int i = this.capacity;
        while (i-- > 0) {
            this.elements.put(i, (int)(obj.longValue() & 0xFFFFFFFFL));
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.length()) {
            ((Buffer)this.elements).limit(n);
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        BasicVector_IntBuffer result = new BasicVector_IntBuffer(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.elements.put(i, this.elements.get(j));
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            int temp = this.elements.get(i);
            this.elements.put(i, this.elements.get(j));
            this.elements.put(j, temp);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newElements = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = initialContents.elt(i);
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new BasicVector_IntBuffer(newElements, this.directAllocation);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newElements = new LispObject[newCapacity];
            System.arraycopy(this.elements.array(), 0, newElements, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newElements[i] = initialElement;
                }
            }
            return new BasicVector_IntBuffer(newElements, this.directAllocation);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }

    @Override
    public AbstractVector replace(AbstractVector source2, int targetStart, int targetEnd, int sourceStart, int sourceEnd) {
        if (source2 instanceof BasicVector_IntBuffer) {
            IntBuffer view = ((BasicVector_IntBuffer)source2).elements.asReadOnlyBuffer();
            view.position(sourceStart);
            view.limit(sourceEnd);
            this.elements.position(targetStart);
            this.elements.put(view);
            this.elements.position(0);
            return this;
        }
        return super.replace(source2, targetStart, targetEnd, sourceStart, sourceEnd);
    }
}

