/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.FuncallableStandardClass;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public class StandardObject
extends LispObject {
    protected Layout layout;
    protected LispObject[] slots;
    private static final Primitive SWAP_SLOTS = new pf_swap_slots();
    private static final Primitive STD_INSTANCE_LAYOUT = new pf_std_instance_layout();
    private static final Primitive _SET_STD_INSTANCE_LAYOUT = new pf__set_std_instance_layout();
    private static final Primitive STD_INSTANCE_CLASS = new pf_std_instance_class();
    private static final Primitive STANDARD_INSTANCE_ACCESS = new pf_standard_instance_access();
    private static final Primitive _SET_STANDARD_INSTANCE_ACCESS = new pf__set_standard_instance_access();
    private static final Primitive STD_SLOT_BOUNDP = new pf_std_slot_boundp();
    private static final Primitive STD_SLOT_VALUE = new pf_std_slot_value();
    private static final Primitive SET_STD_SLOT_VALUE = new pf_set_std_slot_value();
    private static final Primitive _STD_ALLOCATE_INSTANCE = new pf__std_allocate_instance();

    protected StandardObject() {
        this.layout = new Layout((LispObject)StandardClass.STANDARD_OBJECT, Lisp.NIL, (LispObject)Lisp.NIL);
    }

    protected StandardObject(Layout layout) {
        this(layout, layout.getLength());
    }

    protected StandardObject(Layout layout, int length) {
        this.layout = layout;
        this.slots = new LispObject[length];
        int i = this.slots.length;
        while (i-- > 0) {
            this.slots[i] = Lisp.UNBOUND_VALUE;
        }
    }

    protected StandardObject(LispClass cls, int length) {
        this.layout = cls == null ? null : cls.getClassLayout();
        this.slots = new LispObject[length];
        int i = this.slots.length;
        while (i-- > 0) {
            this.slots[i] = Lisp.UNBOUND_VALUE;
        }
    }

    protected StandardObject(LispClass cls) {
        this.layout = cls == null ? null : cls.getClassLayout();
        this.slots = new LispObject[this.layout == null ? 0 : this.layout.getLength()];
        int i = this.slots.length;
        while (i-- > 0) {
            this.slots[i] = Lisp.UNBOUND_VALUE;
        }
    }

    @Override
    public LispObject getParts() {
        LispObject[] slotNames;
        LispObject parts = Lisp.NIL;
        if (this.layout != null && this.layout.isInvalid()) {
            this.layout = this.updateLayout();
        }
        parts = parts.push(new Cons("LAYOUT", (LispObject)this.layout));
        if (this.layout != null && (slotNames = this.layout.getSlotNames()) != null) {
            for (int i = 0; i < slotNames.length; ++i) {
                parts = parts.push(new Cons(slotNames[i], this.slots[i]));
            }
        }
        return parts.nreverse();
    }

    public final LispObject getLispClass() {
        return this.layout.getLispClass();
    }

    private LispObject helperGetClassName() {
        LispObject c1 = this.layout.getLispClass();
        if (c1 instanceof LispClass) {
            return ((LispClass)c1).getName();
        }
        return LispThread.currentThread().execute((LispObject)Symbol.CLASS_NAME, c1);
    }

    private LispObject helperGetCPL() {
        LispObject c1 = this.layout.getLispClass();
        if (c1 instanceof LispClass) {
            return ((LispClass)c1).getCPL();
        }
        return LispThread.currentThread().execute((LispObject)Symbol.CLASS_PRECEDENCE_LIST, c1);
    }

    @Override
    public LispObject typeOf() {
        LispObject c2;
        LispObject c1 = this.layout.getLispClass();
        LispObject name = c1 instanceof LispClass ? ((LispClass)c1).getName() : LispThread.currentThread().execute((LispObject)Symbol.CLASS_NAME, c1);
        if (name != Lisp.NIL && name != Lisp.UNBOUND_VALUE && (c2 = LispClass.findClass(name, false)) == c1) {
            return name;
        }
        return c1;
    }

    @Override
    public LispObject classOf() {
        return this.layout.getLispClass();
    }

    @Override
    public LispObject typep(LispObject type) {
        LispObject cls;
        if (type == Symbol.STANDARD_OBJECT) {
            return Lisp.T;
        }
        if (type == StandardClass.STANDARD_OBJECT) {
            return Lisp.T;
        }
        LispObject lispObject = cls = this.layout != null ? this.layout.getLispClass() : null;
        if (cls != null) {
            if (type == cls) {
                return Lisp.T;
            }
            if (type == this.helperGetClassName()) {
                return Lisp.T;
            }
            for (LispObject cpl = this.helperGetCPL(); cpl != Lisp.NIL; cpl = cpl.cdr()) {
                if (type == cpl.car()) {
                    return Lisp.T;
                }
                LispObject otherClass = cpl.car();
                if (!(otherClass instanceof LispClass ? type == ((LispClass)otherClass).getName() : type == LispThread.currentThread().execute((LispObject)Symbol.CLASS_NAME, otherClass))) continue;
                return Lisp.T;
            }
        }
        return super.typep(type);
    }

    @Override
    public String printObject() {
        LispObject currentPrintLevel;
        int currentLevel;
        LispThread thread = LispThread.currentThread();
        int maxLevel = Integer.MAX_VALUE;
        LispObject printLevel = Symbol.PRINT_LEVEL.symbolValue(thread);
        if (printLevel instanceof Fixnum) {
            maxLevel = ((Fixnum)printLevel).value;
        }
        if ((currentLevel = Fixnum.getValue(currentPrintLevel = Lisp._CURRENT_PRINT_LEVEL_.symbolValue(thread))) >= maxLevel) {
            return "#";
        }
        return this.unreadableString(this.typeOf().printObject());
    }

    synchronized Layout updateLayout() {
        if (!this.layout.isInvalid()) {
            return this.layout;
        }
        Layout oldLayout = this.layout;
        LispObject cls = oldLayout.getLispClass();
        Layout newLayout = cls instanceof LispClass ? ((LispClass)cls).getClassLayout() : (Layout)Symbol.CLASS_LAYOUT.execute(cls);
        Debug.assertTrue(!newLayout.isInvalid());
        StandardObject newInstance = new StandardObject(newLayout);
        Debug.assertTrue(newInstance.layout == newLayout);
        LispObject added = Lisp.NIL;
        LispObject discarded = Lisp.NIL;
        LispObject plist = Lisp.NIL;
        LispObject[] oldSlotNames = oldLayout.getSlotNames();
        for (int i = 0; i < oldSlotNames.length; ++i) {
            LispObject slotName = oldSlotNames[i];
            int j = newLayout.getSlotIndex(slotName);
            if (j >= 0) {
                newInstance.slots[j] = this.slots[i];
                continue;
            }
            discarded = discarded.push(slotName);
            if (this.slots[i] == Lisp.UNBOUND_VALUE) continue;
            plist = plist.push(this.slots[i]);
            plist = plist.push(slotName);
        }
        LispObject rest = oldLayout.getSharedSlots();
        if (rest != null) {
            while (rest != Lisp.NIL) {
                LispObject location = rest.car();
                LispObject slotName = location.car();
                int i = newLayout.getSlotIndex(slotName);
                if (i >= 0) {
                    newInstance.slots[i] = location.cdr();
                }
                rest = rest.cdr();
            }
        }
        LispObject[] newSlotNames = newLayout.getSlotNames();
        for (int i = 0; i < newSlotNames.length; ++i) {
            LispObject location;
            LispObject slotName = newSlotNames[i];
            int j = oldLayout.getSlotIndex(slotName);
            if (j >= 0 || (location = oldLayout.getSharedSlotLocation(slotName)) != null) continue;
            added = added.push(slotName);
        }
        LispObject[] tempSlots = this.slots;
        this.slots = newInstance.slots;
        newInstance.slots = tempSlots;
        Layout tempLayout = this.layout;
        this.layout = newInstance.layout;
        newInstance.layout = tempLayout;
        Debug.assertTrue(!this.layout.isInvalid());
        Symbol.UPDATE_INSTANCE_FOR_REDEFINED_CLASS.execute(this, added, discarded, plist);
        return newLayout;
    }

    public LispObject getInstanceSlotValue(LispObject slotName) {
        Debug.assertTrue(this.layout != null);
        if (this.layout.isInvalid()) {
            this.layout = this.updateLayout();
        }
        Debug.assertTrue(this.layout != null);
        int index = this.layout.getSlotIndex(slotName);
        if (index < 0) {
            LispThread thread = LispThread.currentThread();
            LispObject value = thread.execute(Symbol.SLOT_MISSING, this.getLispClass(), this, slotName, Symbol.SLOT_VALUE);
            thread._values = null;
            return value;
        }
        return this.slots[index];
    }

    public void setInstanceSlotValue(LispObject slotName, LispObject newValue) {
        Debug.assertTrue(this.layout != null);
        if (this.layout.isInvalid()) {
            this.layout = this.updateLayout();
        }
        Debug.assertTrue(this.layout != null);
        int index = this.layout.getSlotIndex(slotName);
        if (index < 0) {
            LispThread thread = LispThread.currentThread();
            thread.execute(Symbol.SLOT_MISSING, this.getLispClass(), this, slotName, Symbol.SETF, newValue);
            thread._values = null;
        }
        this.slots[index] = newValue;
    }

    public static final StandardObject checkStandardObject(LispObject first) {
        if (first instanceof StandardObject) {
            return (StandardObject)first;
        }
        return (StandardObject)Lisp.type_error(first, Symbol.STANDARD_OBJECT);
    }

    @Override
    public LispObject SLOT_VALUE(LispObject slotName) {
        LispObject value;
        LispObject index;
        if (this.layout.isInvalid()) {
            this.layout = this.updateLayout();
        }
        if ((index = this.layout.slotTable.get(slotName)) != null) {
            value = this.slots[((Fixnum)index).value];
        } else {
            LispObject location = this.layout.getSharedSlotLocation(slotName);
            if (location == null) {
                return Symbol.SLOT_MISSING.execute(this.getLispClass(), this, slotName, Symbol.SLOT_VALUE);
            }
            value = location.cdr();
        }
        if (value == Lisp.UNBOUND_VALUE) {
            value = Symbol.SLOT_UNBOUND.execute(this.getLispClass(), this, slotName);
            LispThread.currentThread()._values = null;
        }
        return value;
    }

    @Override
    public void setSlotValue(LispObject slotName, LispObject newValue) {
        LispObject index;
        if (this.layout.isInvalid()) {
            this.layout = this.updateLayout();
        }
        if ((index = this.layout.slotTable.get(slotName)) != null) {
            this.slots[((Fixnum)index).value] = newValue;
            return;
        }
        LispObject location = this.layout.getSharedSlotLocation(slotName);
        if (location != null) {
            location.setCdr(newValue);
            return;
        }
        LispObject[] args = new LispObject[]{this.getLispClass(), this, slotName, Symbol.SETF, newValue};
        Symbol.SLOT_MISSING.execute(args);
    }

    @DocString(name="%std-allocate-instance", args="class", returns="instance")
    private static final class pf__std_allocate_instance
    extends Primitive {
        pf__std_allocate_instance() {
            super("%std-allocate-instance", Lisp.PACKAGE_SYS, true, "class");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg == StandardClass.FUNCALLABLE_STANDARD_CLASS) {
                return new FuncallableStandardClass();
            }
            if (arg == StandardClass.STANDARD_CLASS) {
                return new StandardClass();
            }
            if (arg instanceof StandardClass) {
                StandardClass cls = (StandardClass)arg;
                Layout layout = cls.getClassLayout();
                if (layout == null) {
                    Lisp.program_error("No layout for class " + cls.princToString() + ".");
                }
                return new StandardObject(cls, layout.getLength());
            }
            if (arg.typep(StandardClass.STANDARD_CLASS) != Lisp.NIL) {
                LispObject l = Symbol.CLASS_LAYOUT.execute(arg);
                if (!(l instanceof Layout)) {
                    Lisp.program_error("Invalid standard class layout for class " + arg.princToString() + ".");
                }
                return new StandardObject((Layout)l);
            }
            return Lisp.type_error(arg, Symbol.STANDARD_CLASS);
        }
    }

    @DocString(name="set-std-slot-value")
    private static final class pf_set_std_slot_value
    extends Primitive {
        pf_set_std_slot_value() {
            super(Symbol.SET_STD_SLOT_VALUE, "instance slot-name new-value");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            first.setSlotValue(second, third);
            return third;
        }
    }

    @DocString(name="std-slot-value")
    private static final class pf_std_slot_value
    extends Primitive {
        pf_std_slot_value() {
            super(Symbol.STD_SLOT_VALUE, "instance slot-name");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return first.SLOT_VALUE(second);
        }
    }

    @DocString(name="std-slot-boundp")
    private static final class pf_std_slot_boundp
    extends Primitive {
        pf_std_slot_boundp() {
            super(Symbol.STD_SLOT_BOUNDP, "instance slot-name");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispObject index;
            StandardObject instance = StandardObject.checkStandardObject(first);
            Layout layout = instance.layout;
            if (layout.isInvalid()) {
                layout = instance.updateLayout();
            }
            if ((index = layout.slotTable.get(second)) != null) {
                return instance.slots[((Fixnum)index).value] != Lisp.UNBOUND_VALUE ? Lisp.T : Lisp.NIL;
            }
            LispObject location = layout.getSharedSlotLocation(second);
            if (location != null) {
                return location.cdr() != Lisp.UNBOUND_VALUE ? Lisp.T : Lisp.NIL;
            }
            LispThread thread = LispThread.currentThread();
            LispObject value = thread.execute(Symbol.SLOT_MISSING, instance.getLispClass(), instance, second, Symbol.SLOT_BOUNDP);
            thread._values = null;
            return value != Lisp.NIL ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="%set-standard-instance-access", args="instance location new-value", returns="new-value")
    private static final class pf__set_standard_instance_access
    extends Primitive {
        pf__set_standard_instance_access() {
            super("%set-standard-instance-access", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            StandardObject instance = StandardObject.checkStandardObject(first);
            if (instance.layout.isInvalid()) {
                instance.updateLayout();
            }
            if (!(second instanceof Fixnum)) {
                return Lisp.type_error(second, Symbol.INTEGER);
            }
            int index = ((Fixnum)second).value;
            try {
                instance.slots[index] = third;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (instance.slots.length > 0) {
                    return Lisp.type_error(second, Lisp.list(Symbol.INTEGER, Fixnum.ZERO, Fixnum.getInstance(instance.slots.length - 1)));
                }
                return Lisp.program_error("The object " + instance.princToString() + " has no slots.");
            }
            return third;
        }
    }

    @DocString(name="standard-instance-access", args="instance location", returns="value")
    private static final class pf_standard_instance_access
    extends Primitive {
        pf_standard_instance_access() {
            super("standard-instance-access", Lisp.PACKAGE_SYS, true, "instance location");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispObject value;
            StandardObject instance = StandardObject.checkStandardObject(first);
            if (instance.layout.isInvalid()) {
                instance.updateLayout();
            }
            if (!(second instanceof Fixnum)) {
                return Lisp.type_error(second, Symbol.INTEGER);
            }
            int index = ((Fixnum)second).value;
            try {
                value = instance.slots[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (instance.slots.length > 0) {
                    return Lisp.type_error(second, Lisp.list(Symbol.INTEGER, Fixnum.ZERO, Fixnum.getInstance(instance.slots.length - 1)));
                }
                return Lisp.program_error("The object " + instance.princToString() + " has no slots.");
            }
            return value;
        }
    }

    @DocString(name="std-instance-class")
    private static final class pf_std_instance_class
    extends Primitive {
        pf_std_instance_class() {
            super("std-instance-class", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return StandardObject.checkStandardObject((LispObject)arg).layout.getLispClass();
        }
    }

    @DocString(name="%set-std-instance-layout")
    private static final class pf__set_std_instance_layout
    extends Primitive {
        pf__set_std_instance_layout() {
            super("%set-std-instance-layout", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            StandardObject.checkStandardObject((LispObject)first).layout = Lisp.checkLayout(second);
            return second;
        }
    }

    @DocString(name="std-instance-layout")
    private static final class pf_std_instance_layout
    extends Primitive {
        pf_std_instance_layout() {
            super("std-instance-layout", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            StandardObject instance = StandardObject.checkStandardObject(arg);
            Layout layout = instance.layout;
            if (layout.isInvalid()) {
                layout = instance.updateLayout();
            }
            return layout;
        }
    }

    @DocString(name="swap-slots", args="instance-1 instance-2", returns="nil")
    private static final class pf_swap_slots
    extends Primitive {
        pf_swap_slots() {
            super("swap-slots", Lisp.PACKAGE_SYS, true, "instance-1 instance-2");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            StandardObject obj1 = StandardObject.checkStandardObject(first);
            StandardObject obj2 = StandardObject.checkStandardObject(second);
            LispObject[] temp = obj1.slots;
            obj1.slots = obj2.slots;
            obj2.slots = temp;
            return Lisp.NIL;
        }
    }
}

