/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class GrayStream
extends Stream {
    LispObject clos = null;
    static HashMap<LispObject, GrayStream> objects = new HashMap();
    public static final Symbol INPUT_STREAM_P = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/INPUT-STREAM-P");
    public static final Symbol OUTPUT_STREAM_P = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/OUTPUT-STREAM-P");
    public static final Symbol INTERACTIVE_STREAM_P = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/INTERACTIVE-STREAM-P");
    public static final Symbol OPEN_STREAM_P = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/OPEN-STREAM-P");
    public static final Symbol ELEMENT_TYPE = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/ELEMENT-TYPE");
    public static final Symbol EXTERNAL_FORMAT = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/EXTERNAL-FORMAT");
    public static final Symbol SET_EXTERNAL_FORMAT = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/SET-EXTERNAL-FORMAT");
    public static final Symbol FORCE_OUTPUT = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FORCE-OUTPUT");
    public static final Symbol WRITE_STRING = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/WRITE-STRING");
    public static final Symbol WRITE_CHAR = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/WRITE-CHAR");
    public static final Symbol WRITE_CHARS = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/WRITE-CHARS");
    public static final Symbol FRESH_LINE = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FRESH-LINE");
    public static final Symbol READ_CHAR = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/READ-CHAR");
    public static final Symbol UNREAD_CHAR = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/UNREAD-CHAR");
    public static final Symbol STREAM_LISTEN = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/LISTEN");
    public static final Symbol READ_BYTE = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/READ-BYTE");
    public static final Symbol WRITE_BYTE = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/WRITE-BYTE");
    public static final Symbol CLEAR_INPUT = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/CLEAR-INPUT");
    public static final Symbol FINISH_OUTPUT = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FINISH-OUTPUT");
    public static final Symbol FILE_POSITION = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FILE-POSITION");
    public static final Symbol SET_FILE_POSITION = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/SET-FILE-POSITION");
    public static final Symbol FILE_LENGTH = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FILE-LENGTH");
    public static final Symbol FILE_STRING_LENGTH = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/FILE-STRING-LENGTH");
    public static final Symbol PATHNAME = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/PATHNAME");
    public static final Symbol LINE_COLUMN = Lisp.PACKAGE_GRAY_STREAMS_JAVA.addExternalSymbol("JAVA/LINE-COLUMN");

    private GrayStream(LispObject clos) {
        super(Symbol.CLOS_STREAM);
        this.clos = clos;
    }

    public static synchronized GrayStream findOrCreate(LispObject o) {
        GrayStream wrappedStream = objects.get(o);
        if (wrappedStream == null) {
            wrappedStream = new GrayStream(o);
            objects.put(o, wrappedStream);
        }
        return wrappedStream;
    }

    @Override
    public boolean isInputStream() {
        Function f = Lisp.checkFunction(INPUT_STREAM_P.getSymbolFunction());
        return f.execute(this.clos).getBooleanValue();
    }

    @Override
    public boolean isOutputStream() {
        Function f = Lisp.checkFunction(OUTPUT_STREAM_P.getSymbolFunction());
        return f.execute(this.clos).getBooleanValue();
    }

    @Override
    public boolean isInteractive() {
        Function f = Lisp.checkFunction(INTERACTIVE_STREAM_P.getSymbolFunction());
        return f.execute(this.clos).getBooleanValue();
    }

    @Override
    public boolean isOpen() {
        Function f = Lisp.checkFunction(OPEN_STREAM_P.getSymbolFunction());
        return f.execute(this.clos).getBooleanValue();
    }

    public boolean isCharacterStream() {
        Function subtypep = Lisp.checkFunction(Symbol.SUBTYPEP.getSymbolFunction());
        return subtypep.execute(this.getElementType(), Symbol.CHARACTER).getBooleanValue();
    }

    public boolean isBinaryStream() {
        return !this.isCharacterStream();
    }

    @Override
    public boolean isCharacterInputStream() {
        return this.isCharacterStream() && this.isInputStream();
    }

    @Override
    public boolean isCharacterOutputStream() {
        return this.isCharacterStream() && this.isOutputStream();
    }

    @Override
    public boolean isBinaryInputStream() {
        return this.isBinaryStream() && this.isInputStream();
    }

    @Override
    public boolean isBinaryOutputStream() {
        return this.isBinaryStream() && this.isOutputStream();
    }

    @Override
    public LispObject getElementType() {
        Function f = Lisp.checkFunction(ELEMENT_TYPE.getSymbolFunction());
        return f.execute(this.clos);
    }

    @Override
    public LispObject getExternalFormat() {
        Function f = Lisp.checkFunction(EXTERNAL_FORMAT.getSymbolFunction());
        return f.execute(this.clos);
    }

    @Override
    public void setExternalFormat(LispObject format) {
        Function f = Lisp.checkFunction(SET_EXTERNAL_FORMAT.getSymbolFunction());
        f.execute(this.clos, format);
    }

    public void _forceOutput() {
        Function f = Lisp.checkFunction(FORCE_OUTPUT.getSymbolFunction());
        f.execute(this.clos);
    }

    @Override
    public void _writeString(String string) {
        Function f = Lisp.checkFunction(WRITE_STRING.getSymbolFunction());
        SimpleString s = new SimpleString(string);
        f.execute(this.clos, s);
    }

    @Override
    public void _writeChar(char c) {
        Function f = Lisp.checkFunction(WRITE_CHAR.getSymbolFunction());
        f.execute(this.clos, LispCharacter.getInstance(c));
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        Function f = Lisp.checkFunction(WRITE_CHARS.getSymbolFunction());
        SimpleString string = new SimpleString(chars);
        f.execute(this.clos, string, LispInteger.getInstance(start), LispInteger.getInstance(end));
    }

    @Override
    public LispObject freshLine() {
        Function f = Lisp.checkFunction(FRESH_LINE.getSymbolFunction());
        return f.execute(this.clos);
    }

    @Override
    public int _readChar() {
        Function f = Lisp.checkFunction(READ_CHAR.getSymbolFunction());
        LispObject result = f.execute(this.clos);
        if (result instanceof LispCharacter) {
            return Lisp.checkCharacter(result).getValue();
        }
        return -1;
    }

    @Override
    public void _unreadChar(int n) {
        Function f = Lisp.checkFunction(UNREAD_CHAR.getSymbolFunction());
        f.execute(this.clos, LispCharacter.getInstance((char)n));
    }

    @Override
    protected boolean _charReady() {
        Function f = Lisp.checkFunction(STREAM_LISTEN.getSymbolFunction());
        return STREAM_LISTEN.execute(this.clos).equals(Lisp.T);
    }

    @Override
    protected boolean _byteReady() {
        Lisp.simple_error("unimplemented _byteReady()", new Object[0]);
        return false;
    }

    @Override
    public int _readByte() {
        Function f = Lisp.checkFunction(READ_BYTE.getSymbolFunction());
        LispObject result = f.execute(this.clos);
        return result.intValue();
    }

    @Override
    public void _writeByte(int n) {
        Function f = Lisp.checkFunction(WRITE_BYTE.getSymbolFunction());
        f.execute(this.clos, LispInteger.getInstance(n));
    }

    @Override
    public void _clearInput() {
        Function f = Lisp.checkFunction(CLEAR_INPUT.getSymbolFunction());
        f.execute(this.clos);
    }

    @Override
    public void _finishOutput() {
        Function f = Lisp.checkFunction(FINISH_OUTPUT.getSymbolFunction());
        f.execute(this.clos);
    }

    @Override
    public long _getFilePosition() {
        Function f = Lisp.checkFunction(FILE_POSITION.getSymbolFunction());
        LispObject result = f.execute(this.clos);
        return result.longValue();
    }

    @Override
    public boolean _setFilePosition(LispObject arg) {
        Function f = Lisp.checkFunction(SET_FILE_POSITION.getSymbolFunction());
        return f.execute(this.clos, arg).getBooleanValue();
    }

    @Override
    public LispObject fileLength() {
        Function f = Lisp.checkFunction(FILE_LENGTH.getSymbolFunction());
        return f.execute(this.clos);
    }

    @Override
    public LispObject fileStringLength(LispObject arg) {
        Function f = Lisp.checkFunction(FILE_STRING_LENGTH.getSymbolFunction());
        return f.execute(this.clos, arg);
    }

    @Override
    public Pathname getPathname() {
        Function f = Lisp.checkFunction(PATHNAME.getSymbolFunction());
        return (Pathname)f.execute(this.clos);
    }

    @Override
    public int getCharPos() {
        Function f = Lisp.checkFunction(LINE_COLUMN.getSymbolFunction());
        LispObject result = f.execute(this.clos);
        return result.intValue();
    }

    @Override
    public void setInteractive(boolean b) {
        Lisp.simple_error("unimplemented setInteractive(boolean)", new Object[0]);
    }

    @Override
    public String getEncoding() {
        Lisp.simple_error("unimplemented getEncoding()", new Object[0]);
        return null;
    }

    @Override
    public void setOpen(boolean b) {
        Lisp.simple_error("unimplemented setOpen()", new Object[0]);
    }

    @Override
    public int getOffset() {
        Lisp.simple_error("unimplemented getOffset()", new Object[0]);
        return 0;
    }

    @Override
    public final int getLineNumber() {
        Lisp.simple_error("unimplemented getLineNumber()", new Object[0]);
        return 0;
    }

    static {
        Autoload.autoloadFile(INPUT_STREAM_P, "gray-streams-java");
        Autoload.autoloadFile(OUTPUT_STREAM_P, "gray-streams-java");
        Autoload.autoloadFile(INTERACTIVE_STREAM_P, "gray-streams-java");
        Autoload.autoloadFile(OPEN_STREAM_P, "gray-streams-java");
        Autoload.autoloadFile(ELEMENT_TYPE, "gray-streams-java");
        Autoload.autoloadFile(EXTERNAL_FORMAT, "gray-streams-java");
        Autoload.autoloadFile(SET_EXTERNAL_FORMAT, "gray-streams-java");
        Autoload.autoloadFile(FORCE_OUTPUT, "gray-streams-java");
        Autoload.autoloadFile(WRITE_STRING, "gray-streams-java");
        Autoload.autoloadFile(WRITE_CHAR, "gray-streams-java");
        Autoload.autoloadFile(WRITE_CHARS, "gray-streams-java");
        Autoload.autoloadFile(FRESH_LINE, "gray-streams-java");
        Autoload.autoloadFile(READ_CHAR, "gray-streams-java");
        Autoload.autoloadFile(UNREAD_CHAR, "gray-streams-java");
        Autoload.autoloadFile(STREAM_LISTEN, "gray-streams-java");
        Autoload.autoloadFile(READ_BYTE, "gray-streams-java");
        Autoload.autoloadFile(WRITE_BYTE, "gray-streams-java");
        Autoload.autoloadFile(CLEAR_INPUT, "gray-streams-java");
        Autoload.autoloadFile(FINISH_OUTPUT, "gray-streams-java");
        Autoload.autoloadFile(FILE_POSITION, "gray-streams-java");
        Autoload.autoloadFile(SET_FILE_POSITION, "gray-streams-java");
        Autoload.autoloadFile(FILE_LENGTH, "gray-streams-java");
        Autoload.autoloadFile(FILE_STRING_LENGTH, "gray-streams-java");
        Autoload.autoloadFile(PATHNAME, "gray-streams-java");
        Autoload.autoloadFile(LINE_COLUMN, "gray-streams-java");
    }
}

