/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SimpleVector
extends AbstractVector {
    int capacity;
    LispObject[] data;
    private static final Primitive SVREF = new Primitive("svref", "simple-vector index"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SimpleVector) {
                SimpleVector sv = (SimpleVector)first;
                int index = Fixnum.getValue(second);
                try {
                    return sv.data[index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int capacity = sv.capacity;
                    sv.badIndex(index, capacity);
                    return Lisp.NIL;
                }
            }
            return Lisp.type_error(first, Symbol.SIMPLE_VECTOR);
        }
    };
    private static final Primitive SVSET = new Primitive("svset", Lisp.PACKAGE_SYS, true, "simple-vector index new-value"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof SimpleVector) {
                SimpleVector sv = (SimpleVector)first;
                int index = Fixnum.getValue(second);
                try {
                    sv.data[index] = third;
                    return third;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int capacity = sv.capacity;
                    sv.badIndex(index, capacity);
                    return Lisp.NIL;
                }
            }
            return Lisp.type_error(first, Symbol.SIMPLE_VECTOR);
        }
    };

    public SimpleVector(int capacity) {
        this.data = new LispObject[capacity];
        int i = capacity;
        while (i-- > 0) {
            this.data[i] = Fixnum.ZERO;
        }
        this.capacity = capacity;
    }

    public SimpleVector(LispObject obj) {
        if (obj.listp()) {
            this.data = obj.copyToArray();
            this.capacity = this.data.length;
        } else if (obj instanceof AbstractVector) {
            this.capacity = obj.length();
            this.data = new LispObject[this.capacity];
            for (int i = 0; i < this.capacity; ++i) {
                this.data[i] = obj.elt(i);
            }
        } else {
            Debug.assertTrue(false);
        }
    }

    public SimpleVector(LispObject[] array) {
        this.data = array;
        this.capacity = array.length;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_VECTOR, Fixnum.getInstance(this.capacity));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SIMPLE_VECTOR;
    }

    @Override
    public LispObject getDescription() {
        StringBuffer sb = new StringBuffer("A simple vector with ");
        sb.append(this.capacity);
        sb.append(" elements");
        return new SimpleString(sb);
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.T;
    }

    @Override
    public boolean isSimpleVector() {
        return true;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.data.length);
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, LispObject newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject SVREF(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.data.length);
            return Lisp.NIL;
        }
    }

    @Override
    public void svset(int index, LispObject newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        SimpleVector v = new SimpleVector(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.data[j++] = this.data[i++];
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        int i = this.capacity;
        while (i-- > 0) {
            this.data[i] = obj;
        }
    }

    @Override
    public LispObject deleteEq(LispObject item) {
        int limit = this.capacity;
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.data[i++]) == item) continue;
            this.data[j++] = obj;
        }
        if (j < limit) {
            this.shrink(j);
        }
        return this;
    }

    @Override
    public LispObject deleteEql(LispObject item) {
        int limit = this.capacity;
        int i = 0;
        int j = 0;
        while (i < limit) {
            LispObject obj;
            if ((obj = this.data[i++]).eql(item)) continue;
            this.data[j++] = obj;
        }
        if (j < limit) {
            this.shrink(j);
        }
        return this;
    }

    @Override
    public void shrink(int n) {
        if (n < this.capacity) {
            LispObject[] newData = new LispObject[n];
            System.arraycopy(this.data, 0, newData, 0, n);
            this.data = newData;
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        SimpleVector result = new SimpleVector(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.data[i] = this.data[j];
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            LispObject temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newData = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newData[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newData[i] = initialContents.elt(i);
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new SimpleVector(newData);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newData = new LispObject[newCapacity];
            System.arraycopy(this.data, 0, newData, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newData[i] = initialElement;
                }
            }
            return new SimpleVector(newData);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }

    @Override
    public AbstractVector replace(AbstractVector source2, int targetStart, int targetEnd, int sourceStart, int sourceEnd) {
        if (source2 instanceof SimpleVector) {
            System.arraycopy(((SimpleVector)source2).data, sourceStart, this.data, targetStart, Math.min(targetEnd - targetStart, sourceEnd - sourceStart));
            return this;
        }
        return super.replace(source2, targetStart, targetEnd, sourceStart, sourceEnd);
    }
}

