; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(PROCLAIM '(SPECIAL *multi* *strong-warning* *currfunc* *sysfuncs* *speed*
                    *alist* *exempted-macro* *history* *qi_home_directory*
					*version* *tempsigs* *assoctypes* *maxcomplexity*
                    *backtrack* *occurs* *inferences* *syntax-in* *syntax-out*
                    *special* *extraspecial* *alldatatypes* *datatypes*
                    *synonyms* *maxinferences* *spy* *call* *tc* *step*
                    *Failure* *first_n* *sources* *failure-object* *alphabet*
                    *signatures* *arity* *allsynonyms* *teststack* *st* *ed* *esc*))

;#+LISPWORKS
;(LISPWORKS::LOAD-ALL-PATCHES)

(DEFUN waffle-off ()
   #+CLISP (PROGN (PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0)))
                  (SETQ SYSTEM::*COMPILE-WARNINGS* NIL) 
                  (SETQ *COMPILE-VERBOSE* NIL))
   #+CMU (PROGN (SETQ *COMPILE-PRINT* NIL) 
                (PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0)
                                     (EXTENSIONS::INHIBIT-WARNINGS 3)))
                (SETQ EXTENSIONS::*GC-VERBOSE* NIL))
   #+SBCL (PROGN (SETQ *COMPILE-PRINT* NIL) 
                 (PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0) (DEBUG 0)))
                 (PROCLAIM '(SB-EXT:MUFFLE-CONDITIONS 
                               SB-EXT:COMPILER-NOTE CL:STYLE-WARNING)))
   #+LISPWORKS (PROGN
                 (PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0) (SPACE 0) (DEBUG 0)))
                 (SETF LW:*HANDLE-WARN-ON-REDEFINITION* NIL)
                 (SETQ *COMPILE-VERBOSE* NIL))
   #+ALLEGRO (PROGN (EXCL:SET-CASE-MODE :CASE-SENSITIVE-UPPER)
                    (PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0))))
   #+ABCL (PROGN (SETQ SYSTEM::*COMPILE-WARNINGS* NIL)
                 (SETQ SYSTEM::*COMPILE-VERBOSE* T)
                 (SETQ SYSTEM::*SUPPRESS-COMPILER-WARNINGS* NIL)
                 (SETQ SYSTEM::*WARN-ON-REDEFINITION* NIL))
   #-(OR CLISP CMU SBCL ALLEGRO LISPWORKS ABCL) 
     (ERROR "Unknown platform to Qi: ~A" (LISP-IMPLEMENTATION-TYPE)))

(waffle-off)

(DEFUN quit ()
  #+CLISP
  (EXT:EXIT)
  #+CMU
  (EXT:QUIT)
  #+LISPWORKS
  (LISPWORKS:QUIT)
  #+ALLEGRO
  (EXCL:EXIT)  
  #+SBCL
  (SB-EXT:QUIT)
  #+ABCL
  (EXT:QUIT)
  #-(OR CLISP CMU ALLEGRO SBCL LISPWORKS ABCL)
  (ERROR "Unknown platform to Qi: ~A" (LISP-IMPLEMENTATION-TYPE)))

(DEFUN save ()
  (SETQ *history* NIL)
  #+CLISP
  (EXT:SAVEINITMEM "Qi.mem" :INIT-FUNCTION 'qi)
  #+CMU
  (PROGN (USE-PACKAGE '(:qi)) 
         (EXT:SAVE-LISP "Qi.core" :INIT-FUNCTION 'qi :PRINT-HERALD NIL))
  #+LISPWORKS
  (USER::SAVE-IMAGE "Qi" :RESTART-FUNCTION 'qi::qi :MULTIPROCESSING T :CONSOLE T :ENVIRONMENT NIL)
  #+ALLEGRO 
   (PROGN (SETQ EXCL:*RESTART-INIT-FUNCTION* 'qi)
          (EXCL:DUMPLISP :NAME (FORMAT NIL "~A_~A.dxl" 'Qi *version*) 
               :SUPPRESS-ALLEGRO-CL-BANNER T))
  #+SBCL
     (PROGN (USE-PACKAGE '(:qi)) (SB-EXT:SAVE-LISP-AND-DIE "Qi.core" :TOPLEVEL 'qi))
  #+ABCL
  (PRINT "ABCL does not support save-image")
  #-(OR CLISP CMU LISPWORKS ALLEGRO SBCL ABCL)
  (ERROR "Unknown platform to Qi: ~A" (LISP-IMPLEMENTATION-TYPE)))

;#-(OR SBCL CMU ABCL) (SHADOWING-IMPORT '! :USER)
;#-(OR SBCL CMU ABCL) (USE-PACKAGE '(:qi) :USER)

#-(OR SBCL CMU)
  (DEFCONSTANT *alphabet* '(A B C D E F G H I J K L M N O P Q R S T U V W X Y Z))

;; SBCL compilation of DEFCONSTANT is a bit screwed
#+(OR SBCL CMU) (SETQ *alphabet* '(A B C D E F G H I J K L M N O P Q R S T U V W X Y Z))

#-(OR SBCL CMU) (DEFCONSTANT *sysfuncs* 
  '(<e> and append apply assoc assoc-type boolean? cd character? compile complex? concat congruent? cons? cons datatype debug declare define defcc delete-file destroy difference do dump echo element? empty? error eval explode fail-if findall fix float? freeze fst gensym get-array get-prop head identical if if-with-checking if-without-checking include include-all-but input input+ integer? inferences intersection length let lineread list load m-prolog make-array make-string map mapcan maxinferences multi newsym newvar not nth number? occurrences occurs-check or opaque output print profile preclude preclude-all-but profile-results prolog? ps put-array put-prop quit random rational? read-char read-file-as-charlist read-file read-chars-as-stringlist real? remove reverse round rule s-prolog save set set-comment-delimiter-start set-comment-delimiter-end set-escape-character snd specialise speed spy sqrt step string? strong-warning sugarlist sugar subst symbol? synonyms tail tc thaw time track transparent tuple? type typecheck unassoc-type undebug union unprofile unsugar untrack value unspecialise variable? version warn write-to-file y-or-n? qi_> qi_< qi_>= qi_<= qi_= + * / /. - qi_= == @p when is bind return call))

#+(OR SBCL CMU) (SETQ *sysfuncs* 
  '(<e> and append apply assoc assoc-type boolean? cd character? compile complex? concat congruent? cons? cons datatype debug declare define defcc delete-file destroy difference do dump echo element? empty? error eval explode fail-if findall fix float? freeze fst gensym get-array get-prop head identical if if-with-checking if-without-checking include include-all-but input input+ integer? inferences intersection length let lineread list load m-prolog make-array make-string map mapcan maxinferences multi newsym newvar not nth number? occurrences occurs-check or opaque output print profile preclude preclude-all-but profile-results prolog? ps put-array put-prop quit random rational? read-char read-file-as-charlist read-file read-chars-as-stringlist real? remove reverse round rule set-comment-delimiter-start set-comment-delimiter-end set-escape-character s-prolog save set snd specialise speed spy sqrt step string? strong-warning sugarlist sugar subst symbol? synonyms tail tc thaw time track transparent tuple? type typecheck unassoc-type undebug union unprofile unsugar untrack value unspecialise variable? version warn write-to-file y-or-n? qi_> qi_< qi_>= qi_<= qi_= + * / /. - qi_= == @p when is bind return call))

;; for the benefit of Allegro Linux
(SETQ *PRINT-READABLY* NIL)
