(require 'pprint)
(require 'gray-streams)

(in-package :gray-streams)

(defparameter *debug-args* nil)
(defparameter *args* nil)

(defmethod stream-write-string ((stream t) string &optional start end)
  (warn "stream-write-string invoked with unhandled stream type: ~A~%" 
	(type-of stream)))

(defmethod stream-write-string ((stream xp::xp-structure) string
				&optional (start 0) (end (length string)))
  (when *debug-args*
    (push (list :stream-write-string stream string start end) *args*))
  (let ((start (or start 0))
	(end (or end (length string))))
    (xp::write-string+ string stream start end)))

(defmethod stream-write-char ((stream t) char)
  (warn "stream-write-char invoked with unhandled stream type: ~A~%" 
	(type-of stream)))

(defmethod stream-write-char ((stream xp::xp-structure) char)
  (when *debug-args*
    (push (list :stream-write-char stream char) *args*))
  (xp::write-char+ char stream))
